@echo off
setlocal ENABLEDELAYEDEXPANSION

REM Modifiable Parameter Types
REM "DRIVER=": Specify the name of the driver to be installed. 
REM "PORT=": Specifies the port name of the installed driver. 
REM "IP=": Specify the IP address of the installed driver. 
REM "PRINTER="Specifies the name by which the printer will be displayed.
set "DRIVER="
set "IP="
set "PORT="
set "PRINTER="

REM Your Installation Directory
set "defaultDir=%ProgramFiles%"
set "defaultFolder=DC8600-x86_64-Windows-Driver-V2.127.0.0"
set "destination=!defaultDir!\!defaultFolder!"

:silentInstall
REM Run Silent Install
set "curDir=%~dp0"
set "logDir=!destination!\SetupLog.txt"
set "exePath=!curDir!\DC8600-x86_64-Windows-Driver-V2.127.0.0.exe"
!exePath! /verysilent /IP="!IP!" /PORT="!PORT!" /DRIVER="!DRIVER!" /PRINTER=!PRINTER!

REM Output .bat run start time
call :startTime

:installStatus
REM Detecting Duplicate Installations
set "markFile=!destination!\marks"
if exist !markFile! (
    set /a lineNum=0
    for /f "usebackq delims=" %%a in ("!markFile!") do (
        set /a lineNum+=1
        set "line=%%a"
        call :checkMarksStatus !lineNum! !line! 0
		if !errorlevel! equ 0 (
			REM echo 2^>Verify: Detect Already Exists, exit installation.
			echo 2^>Verify: Detect Already Exists, exit installation.  >>!logDir!
			goto :endTime
		)
    )
)


REM VerifyFileIntegrity
REM Use Hash-Algorithm-MD5 to Verify
REM echo 0^>Verify: Hash Algorithm: MD5
echo 0^>Verify: Hash Algorithm: MD5 >>!logDir!
set /a "index=1"
set /a "fileSum=18"
set /a "fileEnd=fileSum+1"
set /a "fileCorrupted=0"

REM Key-MD5
set "_2k_DSMR600SM_EXE=e7e912c69e2f849e53a76b333fc1eb01"
set "_2k_DSMR600CL_DLL=e62addb783e825c4842a406303d2a6aa"
set "_2k_DSMR600FM_DLL=ebbbedf93f8309cf19db0ae2b38f60bd"
set "_2k_DSMR600LM_DLL=dec3859a9019846b171398186737c9aa"
set "_2k_DSMR600RC_DLL=ee0484d7523bf70ebb7012b141242053"
set "_2k_DSMR600UI_DLL=b483ea47dc75f64cd697ec43cead43f4"
set "_2k_DSMR600UNI_DLL=152afc4eef5a6224068d93ed45ad8882"
set "_64_DSMR600SM_EXE=59436554598be377eaac4267290918e9"
set "_64_DSMR600CL_DLL=e90a87786e8c70627ad5b1406e465be0"
set "_64_DSMR600FM_DLL=36c9ec2a2c6e18b7fb8ac75101681e81"
set "_64_DSMR600LM_DLL=f553c46a93f64104d1f6d60dd50cf781"
set "_64_DSMR600RC_DLL=db0e6d1ee7da709b7c2a331501cbbd2b"
set "_64_DSMR600UI_DLL=279993009c09ceb83b7cc13ab7513d48"
set "_64_DSMR600UNI_DLL=9974c8a60d9a3fe726c5f083781639be"
set "_i386_DSMR600TCPPortMon_DLL=8b917083cb503ee66fe327039b2b0303"
set "_i386_DSMR600TCPPortMonUI_DLL=c03bd383577585ca95a0d9edfab221d4"
set "_x64_DSMR600TCPPortMon_DLL=729445709027bd7218a866c286bddd1d"
set "_x64_DSMR600TCPPortMonUI_DLL=484e1761d6d95c5fff3add29a27c0c42"

set "unzipPath=!destination!\Driver\Printer Driver"
set "_2kPath=2k"
set "_64Path=64"
set "_i386Path=TcpPortMon\i386"
set "_x64Path=TcpPortMon\x64"
set "DSMR600SM_EXE=DSMR600SM.exe"
set "DSMR600CL_DLL=DSMR600CL.dll"
set "DSMR600FM_DLL=DSMR600FM.dll"
set "DSMR600LM_DLL=DSMR600LM.dll"
set "DSMR600RC_DLL=DSMR600RC.dll"
set "DSMR600UI_DLL=DSMR600UI.dll"
set "DSMR600UNI_DLL=DSMR600UNI.dll"
set "DSMR600TCPPortMon_DLL=DSMR600TCPPortMon.dll"
set "DSMR600TCPPortMonUI_DLL=DSMR600TCPPortMonUI.dll"

:1
set "compareMD5=!_2k_DSMR600SM_EXE!"
set "verifyPath=!unzipPath!\!_2kPath!\!DSMR600SM_EXE!"
goto :VerifyFileIntegrity

:2
set "compareMD5=!_2k_DSMR600CL_DLL!"
set "verifyPath=!unzipPath!\!_2kPath!\!DSMR600CL_DLL!"
goto :VerifyFileIntegrity

:3
set "compareMD5=!_2k_DSMR600FM_DLL!"
set "verifyPath=!unzipPath!\!_2kPath!\!DSMR600FM_DLL!"
goto :VerifyFileIntegrity

:4
set "compareMD5=!_2k_DSMR600LM_DLL!"
set "verifyPath=!unzipPath!\!_2kPath!\!DSMR600LM_DLL!"
goto :VerifyFileIntegrity

:5
set "compareMD5=!_2k_DSMR600RC_DLL!"
set "verifyPath=!unzipPath!\!_2kPath!\!DSMR600RC_DLL!"
goto :VerifyFileIntegrity

:6
set "compareMD5=!_2k_DSMR600UI_DLL!"
set "verifyPath=!unzipPath!\!_2kPath!\!DSMR600UI_DLL!"
goto :VerifyFileIntegrity

:7
set "compareMD5=!_2k_DSMR600UNI_DLL!"
set "verifyPath=!unzipPath!\!_2kPath!\!DSMR600UNI_DLL!"
goto :VerifyFileIntegrity

:8
set "compareMD5=!_64_DSMR600SM_EXE!"
set "verifyPath=!unzipPath!\!_64Path!\!DSMR600SM_EXE!"
goto :VerifyFileIntegrity

:9
set "compareMD5=!_64_DSMR600CL_DLL!"
set "verifyPath=!unzipPath!\!_64Path!\!DSMR600CL_DLL!"
goto :VerifyFileIntegrity

:10
set "compareMD5=!_64_DSMR600FM_DLL!"
set "verifyPath=!unzipPath!\!_64Path!\!DSMR600FM_DLL!"
goto :VerifyFileIntegrity

:11
set "compareMD5=!_64_DSMR600LM_DLL!"
set "verifyPath=!unzipPath!\!_64Path!\!DSMR600LM_DLL!"
goto :VerifyFileIntegrity

:12
set "compareMD5=!_64_DSMR600RC_DLL!"
set "verifyPath=!unzipPath!\!_64Path!\!DSMR600RC_DLL!"
goto :VerifyFileIntegrity

:13
set "compareMD5=!_64_DSMR600UI_DLL!"
set "verifyPath=!unzipPath!\!_64Path!\!DSMR600UI_DLL!"
goto :VerifyFileIntegrity

:14
set "compareMD5=!_64_DSMR600UNI_DLL!"
set "verifyPath=!unzipPath!\!_64Path!\!DSMR600UNI_DLL!"
goto :VerifyFileIntegrity

:15
set "compareMD5=!_i386_DSMR600TCPPortMon_DLL!"
set "verifyPath=!unzipPath!\!_i386Path!\!DSMR600TCPPortMon_DLL!"
goto :VerifyFileIntegrity

:16
set "compareMD5=!_i386_DSMR600TCPPortMonUI_DLL!"
set "verifyPath=!unzipPath!\!_i386Path!\!DSMR600TCPPortMonUI_DLL!"
goto :VerifyFileIntegrity

:17
set "compareMD5=!_x64_DSMR600TCPPortMon_DLL!"
set "verifyPath=!unzipPath!\!_x64Path!\!DSMR600TCPPortMon_DLL!"
goto :VerifyFileIntegrity

:18
set "compareMD5=!_x64_DSMR600TCPPortMonUI_DLL!"
set "verifyPath=!unzipPath!\!_x64Path!\!DSMR600TCPPortMonUI_DLL!"
goto :VerifyFileIntegrity

:VerifyFileIntegrity
REM echo 0^>Verify: File: !verifyPath!
echo 0^>Verify: File: !verifyPath! >> !logDir!
for /f "delims=" %%a in ('
    certutil -hashfile "!verifyPath!" MD5 ^| findstr /r "[0-9a-f]" ^| findstr /v "CertUtil"
') do (
    set "ret=%%a"
)
if not !ret!==!compareMD5! (
	set /a "fileCorrupted+=1"
    REM echo 2^>Verify - Result: [Corrupted], File -^> !verifyPath!
    echo 2^>Verify - Result: [Corrupted], File -^> !verifyPath! >>  !logDir!
) 
set /a "index+=1"
if !index! equ !fileEnd! (
	goto :VerifyEnd
) else (
	goto :!index!
)

:VerifyEnd
set "dataTime=%time%"
if !fileCorrupted! equ 0 (
REM echo 0^>Verify: Corrupted file count: !fileCorrupted!
echo 0^>Verify: Corrupted file count: !fileCorrupted! >>!logDir!
) else (
REM echo 2^>Verify: Corrupted file count: !fileCorrupted!
echo 2^>Verify: Corrupted file count: !fileCorrupted! >>!logDir!
)
goto :endTime

:checkMarksStatus
setlocal
set lineNum=%1
set line=%2
set num=%3
set /a "groupNum=num/32 + 1"
if !groupNum! neq !lineNum! (
    endlocal & exit /b 1
)
set /a "bitMask=1<<(num%%32)"
set "hexValue=!line:0x=!"
set /a decValue=0x!hexValue!
set /a "result=decValue & bitMask"
if !result! neq 0 (
    endlocal & exit /b 0
) else (
    endlocal & exit /b 1
)

:startTime
set "dateTime=%time%"
REM echo 0^>Verify: Start time: !dateTime!
echo 0^>Verify: Start time: !dateTime! >>!logDir!
goto :eof

:endTime
set "dateTime=%time%"
REM echo 0^>Verify: Finish time: !dateTime!
echo 0^>Verify: Finish time: !dateTime! >>!logDir!
echo. >> !logDir!
goto :eof

